#include <iostream>
#include <cstdlib>
#include <algorithm>
#include <numeric>
#include <functional>
#include <vector>
#include <iomanip>

using namespace std;

/* Buchung */
class Buchung {
 time_t t;
 double sum;
 public:
 explicit Buchung(double s) :sum(s) { t = time(0); }
 Buchung() :sum(0.0) { t= time(0);}
 Buchung(const Buchung& b) :t(b.t),sum(b.sum) {}
 time_t  btime() const {return t;}
 double summe() const { return sum; }
};

/* Konto */
struct Konto {
 long KontoNr;
 string Name;
 vector<Buchung> Posten;
};

bool operator==(const Konto &k,const long knr)
{
 return k.KontoNr==knr;
}

bool operator==(const Konto &k,const string &s)
{
 return k.Name==s;
}

double sumPosten(double init,const Buchung& b)
{
 return init+b.summe();
}

ostream & operator<<(ostream &o,const Konto &k)
{
 o << "KontoNr: " << setw(8) << k.KontoNr << "\tName: "<< k.Name << "\tBetrag: " << setw(8) << accumulate(k.Posten.begin(),k.Posten.end(),0.0,sumPosten) << endl;
 return o;
}

int numPosten(int init,const Konto& k)
{
 return init+k.Posten.size();
}

/* Hilfsfunktionen */

void display(const Konto &k)
{
 cout << k;
}

bool knrisless(const Konto &k1,const Konto &k2)
{
 return k1.KontoNr<k2.KontoNr;
}

bool nameisless(const Konto &k1,const Konto &k2)
{
 return k1.Name<k2.Name;
}

bool betragisless(const Konto &k1,const Konto &k2)
{
 return accumulate(k1.Posten.begin(),k1.Posten.end(),0.0,sumPosten) < accumulate(k2.Posten.begin(),k2.Posten.end(),0.0,sumPosten);
}

/* Beispieldaten */

Konto k0[] = {
 {20301,"Tester"},
 {22502,"Versuch"},
 {13434,"Maier"},
 {23545,"Irgendwas"},
 { 3423,"Meister"}
};

/* Hauptprogramm */

int main()
{
 cout << "Kontodemo" << endl;
 vector<Konto> Konten;

 Konten.assign(k0,k0+5); // vorgegebene Konten anlegen

 srand(time(0)); // seed randomizer

 for(int i=0;i<20;++i)
 { // 20 zufaellige Buchungen eintragen
  const uint l = rand()%5;
  const double v = (-10000 + rand()%20000) / 100.0;
  Konten[l].Posten.push_back(Buchung(v));
 }

 for_each(Konten.begin(),Konten.end(),display); // Alles ausgeben

 if( Konten[0] == "Tester" && Konten[4] == 3423 ) cout << "override ok!" << endl;

 cout << "nach KontoNr" << endl;
 sort(Konten.begin(),Konten.end(),knrisless);// sortieren nach KontoNr
 for_each(Konten.begin(),Konten.end(),display); // Alles ausgeben

 cout << "nach Name" << endl;
 sort(Konten.begin(),Konten.end(),nameisless);// sortieren nach Name
 for_each(Konten.begin(),Konten.end(),display); // Alles ausgeben

 cout << "nach Betrag" << endl;
 sort(Konten.begin(),Konten.end(),betragisless);// sortieren nach Betrag
 for_each(Konten.begin(),Konten.end(),display); // Alles ausgeben

 cout << "Anzahl der Posten: " << accumulate(Konten.begin(),Konten.end(),0,numPosten) << endl;

 return 0;
}
