#include <iostream>
#include <cstdlib>

using namespace std;

/* Strukturen */

struct Date {
 int Tag,Monat,Jahr;
 int Stunde,Minute,Sekunde;
};

struct Buchung {
 Buchung *next;
 Date date;
 double sum;
};

struct Konto {
 Konto *next;
 Buchung *transaktionen;
 double summe;
 string inhaber;
 int nr;
};

Konto *konten=0;
uint numKonten=0;

/* Funktionen deklarieren */
Konto *neuesKonto(string i);
Buchung *neueBuchung(Konto *r,double s);
void listeKonten();
void KontoDetails(Konto *k);
void zeigeDatum(Date &d);

/* Implementierung */ 
void zeigeDatum(Date &d)
{
  cout << d.Jahr << "-" << d.Monat << "-" << d.Tag;
  cout << " " << d.Stunde << ":" << d.Minute << ":" << d.Sekunde;
}

Konto *neuesKonto(string i)
{
 Konto *neu = new Konto;
 neu->inhaber = i;
 neu->nr = ++numKonten;
 neu->transaktionen=0;
 neu->next = konten;
 konten = neu; 
 return neu;
}

Buchung *neueBuchung(Konto *r,double s)
{
 Buchung *b = new Buchung;
 b->sum = s;
 r->summe += s;
 b->next = r->transaktionen;
 r->transaktionen = b;
 return b;
}

void listeKonten()
{
 cout << "Nr\tName\tGuthaben\n";
 for(Konto *k = konten;k;k=k->next)
 {
   cout << k->nr << "\t" << k->inhaber << "\t" << k->summe << endl;	
 }
 cout << endl;
}

void KontoDetails(Konto *k)
{
  cout << "Nr\tName\tGuthaben\n";
  cout << k->nr << "\t" << k->inhaber << "\t" << k->summe << endl;
  cout << endl << "Transaktionen:" << endl;
  cout << "Betrag\tZeitpunkt" << endl;
  for(Buchung *b=k->transaktionen;b;b=b->next)
  {
   cout << b->sum << "\t";
   zeigeDatum(b->date);
   cout << endl;
  }
  cout << endl;
}

int main(int argc, char *argv[])
{
  Konto *k1 = neuesKonto("Test1");
  Buchung *b1 = neueBuchung(k1,12.0);
  Konto *k2 = neuesKonto("Test2");
  neueBuchung(k2,13.0);
  neueBuchung(k2,-14.4);
  neueBuchung(k2,23.0);
  listeKonten();
  KontoDetails(k1);
  KontoDetails(k2);
  return EXIT_SUCCESS;
}
