/** Noten v4 **/

#include <iostream>
#include <fstream>
#include <cstdlib>

using namespace std;

// Die Datenstruktur Note, sammelt alle Informationen zu einer Note in einer Einheit
struct Note
{
	double Note;
	string Fach;
};

// Damit unsere Funktionen die Noten sehen knnen, mssen wir sie hier oberhalb der Funktionen declarieren
Note Noten[10];
int position=0;

void Schreiben(char* filename)
{
	ofstream out(filename);
	out << "#Notenverwaltung_v4";
	for(int i=0;i<position;i++)
		out << '\n' << Noten[i].Note << "\t" << Noten[i].Fach;
	out.close();
}

void Lesen(char* filename)
{
	ifstream in(filename);
	string s;
	in >> s;
	if(s!= "#Notenverwaltung_v4") {
		cout << "\nDateiformat nicht untersttzt!\n";
		return ;
	}
	position =0;
	while(!in.eof() && position<10)
	{
		double note;
		string s;
		in >> note >>  s ;
		Noten[position].Note = note;
		Noten[position].Fach = s;
		position++;
	}
}

void NoteEingeben()
{
	// Eingeben
	cout << "Bitte das Fach eingeben: ";
	string s;
	cin >> s;
	cout << "Bitte Note eingeben: ";
	double note;
	cin >> note;
	if(position>=10)
	{
		cout << "Kein Platz mehr\n";
		return;
	}
	if(note > 6 || note < 1  )
		cout << "Falsche Eingabe\n";
	else
	{
		Noten[position].Note = note;
		Noten[position].Fach = s;
		position += 1;
	}
}

void NotenAusgeben()
{
	// Ausgeben
	cout << "\n\tNoten:\n";
	for(int i=0; i<position;i++)
		cout << i+1 << ": " << Noten[i].Fach << " " <<Noten[i].Note << "\n";
}

double durchschnitt()
{
	// Durchschnitt
	double sum=0.0;
	for(int i=0; i<position;i++)
		 sum += Noten[i].Note;
	return sum/position;
}

void DurchschnittAusgeben()
{
	cout << "\tDurchschnitt:" << durchschnitt() << endl;
}

int main(int argc, char *argv[])
{
  cout << "Notenverwaltung" << endl;
  bool beenden=false;

  do // Hauptschleife
  {
	  cout << "\n\tMenu\n";
	  cout << "1: Eingeben\n";
	  cout << "2: Ausgeben\n";
	  cout << "3: Durchschnitt\n";
	  cout << "8: Laden\n";
	  cout << "9: Speichern\n";
	  cout << "0: beenden\n";
	  cout << ":";
	  int eingabe;
	  cin >> eingabe;
	  double sum=0.0;
	  switch(eingabe)
	  {
		  case 1:
			  NoteEingeben();
			  break;
		  case 2:
			  NotenAusgeben();
			  break;
		  case 3:
			  DurchschnittAusgeben();
			  break;
		  case 8:
			  Lesen("notenbuch4");
			  break;
		  case 9:
			  Schreiben("notenbuch4");
			  break;
		  case 0:
			  beenden = true;
			  break;
		  default:
			  cout << "unbekannte Eingabe\n";
	  }
  }
  while(!beenden);
  
  return EXIT_SUCCESS;
}
