/** Noten v6
 *  Mit Klassen
 *  Mit Dynamischer Speicherverwaltung,
 *  d.h. Es knnen beliebing viele Noten eingegeben werden **/

#include <iostream>
#include <fstream>
#include <cstdlib>

using namespace std;

// Die Datenstruktur Note, sammelt alle Informationen zu einer Note in einer Einheit
struct Note
{
	Note *next; // Zeiger auf die nchste Note in der Liste
	double Note;
	string Fach;
};

class NotenListe
{
 Note *Noten,*position;
 public:
 NotenListe()
 :Noten(0),position(0)
{
}

void removeAll()
{
	Note *p = Noten;
	Noten = 0;
	position =0;
	while(p)
	{
		Note *o = p;
		p = p->next;
		delete o;
	}
}
void Schreiben(char* filename)
{
	ofstream out(filename);
	out << "#Notenverwaltung_v5";
	for(Note *p=Noten;p;p = p->next)
		out << '\n' << p->Note << "\t" << p->Fach;
	out.close();
}
void Lesen(char* filename)
{
	ifstream in(filename);
	string s;
	in >> s;
	if(s!= "#Notenverwaltung_v5") {
		cout << "\nDateiformat nicht untersttzt!\n";
		return ;
	}
	removeAll();
	Noten = new Note();
	position = Noten;
	Note *op;
	while(!in.eof())
	{
		double note;
		string s;
		in >> note >>  s ;
		position->Note = note;
		position->Fach = s;
		position->next = new Note();
		op = position;
		position = position->next;
		position->next = 0;
	}
	op->next=0;
	delete position;
	position = op;
}

void einfuegen(Note *n)
{
	if(!Noten)
	{
		Noten = n;
		position = Noten;
		position->next = 0;
	}
	else
	{
		position->next = n;
		position = position->next;
		position->next = 0;
	}
}

void ausgeben()
{
	// Ausgeben
	for(Note *p=Noten;p;p = p->next)
		cout << p->Fach << "\t" << p->Note << "\n";
}

double durchschnitt()
{
	// Durchschnitt
	double sum=0.0;
	int c =0;
	for(Note *p=Noten;p;p = p->next)
	{
		sum += p->Note;
		c++;
	}
	return sum/c;
}

};

// Damit unsere Funktionen die Noten sehen knnen, mssen wir sie hier oberhalb der Funktionen declarieren
void NoteEingeben(NotenListe &l)
{
	// Eingeben
	cout << "Bitte das Fach eingeben: ";
	string s;
	cin >> s;
	cout << "Bitte Note eingeben: ";
	double note;
	cin >> note;
	if(note > 6 || note < 1  )
		cout << "Falsche Eingabe\n";
	else
	{
		Note *neu = new Note();
		neu->Note = note;
		neu->Fach = s;
		l.einfuegen(neu);
	}
}

void NotenAusgeben(NotenListe &l)
{
	// Ausgeben
	cout << "\n\tNoten:\n";
	l.ausgeben();
}

void DurchschnittAusgeben(NotenListe &l)
{
	cout << "\tDurchschnitt:" << l.durchschnitt() << endl;
}

int main(int argc, char *argv[])
{
  cout << "Notenverwaltung" << endl;
  bool beenden=false;
  NotenListe Noten;

  do // Hauptschleife
  {
	  cout << "\n\tMenu\n";
	  cout << "1: Eingeben\n";
	  cout << "2: Ausgeben\n";
	  cout << "3: Durchschnitt\n";
	  cout << "8: Laden\n";
	  cout << "9: Speichern\n";
	  cout << "0: beenden\n";
	  cout << ":";
	  int eingabe;
	  cin >> eingabe;
	  double sum=0.0;
	  switch(eingabe)
	  {
		  case 1:
			  NoteEingeben(Noten);
			  break;
		  case 2:
			  NotenAusgeben(Noten);
			  break;
		  case 3:
			  DurchschnittAusgeben(Noten);
			  break;
		  case 8:
			  Noten.Lesen("notenbuch4");
			  break;
		  case 9:
			  Noten.Schreiben("notenbuch4");
			  break;
		  case 0:
			  beenden = true;
			  break;
		  default:
			  cout << "unbekannte Eingabe\n";
	  }
  }
  while(!beenden);

  return EXIT_SUCCESS;
}
