main.cpp:
/** Noten v7
 *  Auf mehrere Dateien verteilt
 *  Mit Klassen
 *  Mit Dynamischer Speicherverwaltung,
 *  d.h. Es knnen beliebing viele Noten eingegeben werden **/

#include <iostream>
#include <fstream>
#include <cstdlib>
#include "notenliste.h"
using namespace std;

void NoteEingeben(NotenListe &l)
{
	// Eingeben
	cout << "Bitte das Fach eingeben: ";
	string s;
	cin >> s;
	cout << "Bitte Note eingeben: ";
	double note;
	cin >> note;
	if(note > 6 || note < 1  )
		cout << "Falsche Eingabe\n";
	else
	{
		Note *neu = new Note(s,note);
		l.einfuegen(neu);
	}
}

int main(int argc, char *argv[])
{
  cout << "Notenverwaltung" << endl;
  bool beenden=false;
  NotenListe Noten;

  do // Hauptschleife
  {
	  cout << "\n\tMenu\n";
	  cout << "1: Eingeben\n";
	  cout << "2: Ausgeben\n";
	  cout << "3: Durchschnitt\n";
	  cout << "8: Laden\n";
	  cout << "9: Speichern\n";
	  cout << "0: beenden\n";
	  cout << ":";
	  int eingabe;
	  cin >> eingabe;
	  double sum=0.0;
	  switch(eingabe)
	  {
		  case 1:
			  NoteEingeben(Noten);
			  break;
		  case 2:
			  cout << "\n\tNoten:\n";
                          Noten.ausgeben();
			  break;
		  case 3:
			  cout << "\tDurchschnitt:" << Noten.durchschnitt() << endl;
			  break;
		  case 8:
			  Noten.lesen("notenbuch4");
			  break;
		  case 9:
			  Noten.schreiben("notenbuch4");
			  break;
		  case 0:
			  beenden = true;
			  break;
		  default:
			  cout << "unbekannte Eingabe\n";
	  }
  }
  while(!beenden);

  return EXIT_SUCCESS;
}

notenliste.h
/** Noten v7
 * Auf mehrere Dateien verteilt
 *  Mit Klassen
 *  Mit Dynamischer Speicherverwaltung,
 *  d.h. Es knnen beliebing viele Noten eingegeben werden **/

#ifndef _NOTENLISTE_
#define _NOTENLISTE_

#include <iostream>
#include <fstream>
#include <cstdlib>

using namespace std;

// Die Datenstruktur Note, sammelt alle Informationen zu einer Note in einer Einheit
class Note
{
 double note;
 string Fach;
 Note *next; // Zeiger auf die nchste Note in der Liste
public:
 Note(); // Konstruktor ohne Parameter
 Note(const string &f,double n); // Konstrukor mit Fach und Note

 friend class NotenListe; // Die Klasse NotenListe darf auf unsere Private und Protected Members zugreifen
};

class NotenListe
{
 Note *Noten,*position; // Zeiger auf erstes und letzte Element
 public:
 NotenListe();
 void removeAll();
 void schreiben(char* filename);
 void lesen(char* filename);
 void einfuegen(Note *n);
 void ausgeben();
 double durchschnitt();
};
#endif

notenliste.cpp:
/** Noten v7
 * Auf mehrere Dateien verteilt
 *  Mit Klassen
 *  Mit Dynamischer Speicherverwaltung,
 *  d.h. Es knnen beliebing viele Noten eingegeben werden **/

#include <iostream>
#include <fstream>
#include <cstdlib>
using namespace std;
#include "notenliste.h"

Note::Note(const string &f,double n)
	:Fach(f),note(n),next(0)
{
}
Note::Note()
	:next(0)
{
}

NotenListe::NotenListe()
 :Noten(0),position(0)
{
}

void NotenListe::removeAll()
{
	Note *p = Noten;
	Noten = 0;
	position =0;
	while(p)
	{
		Note *o = p;
		p = p->next;
		delete o;
	}
}
void NotenListe::schreiben(char* filename)
{
	ofstream out(filename);
	out << "#Notenverwaltung_v5";
	for(Note *p=Noten;p;p = p->next)
		out << '\n' << p->note << "\t" << p->Fach;
	out.close();
}
void NotenListe::lesen(char* filename)
{
	ifstream in(filename);
	string s;
	in >> s;
	if(s!= "#Notenverwaltung_v5") {
		cout << "\nDateiformat nicht untersttzt!\n";
		return ;
	}
	removeAll();
	Noten = new Note();
	position = Noten;
	Note *op;
	while(!in.eof())
	{
		double note;
		string s;
		in >> note >>  s ;
		position->note = note;
		position->Fach = s;
		position->next = new Note();
		op = position;
		position = position->next;
		position->next = 0;
	}
	op->next=0;
	delete position;
	position = op;
}

void NotenListe::einfuegen(Note *n)
{
	if(!Noten)
	{
		Noten = n;
		position = Noten;
		position->next = 0;
	}
	else
	{
		position->next = n;
		position = position->next;
		position->next = 0;
	}
}

void NotenListe::ausgeben()
{
	// Ausgeben
	for(Note *p=Noten;p;p = p->next)
		cout << p->Fach << "\t" << p->note << "\n";
}

double NotenListe::durchschnitt()
{
	// Durchschnitt
	double sum=0.0;
	int c =0;
	for(Note *p=Noten;p;p = p->next)
	{
		sum += p->note;
		c++;
	}
	return sum/c;
}

