#include <iostream>
#include <cstdlib>
#include <time.h>
#include <vector>
#include <algorithm>

void inline swap(int a[],const long i,const long j)
{
 const int s = a[i];
 a[i] = a[j];
 a[j] = s;
}

void selectionsort(int a[],long N)
{
 int min;
 for(long i=0;i<N;i++)
 {
  min = i;
  for(int j=i+1;j<=N;j++)
   if(a[j]<a[min]) min=j;
  swap(a,min,i);
 }
}

void insertionsort(int a[],long N)
{
 for(long i=1;i<N;i++)
 {
  int v = a[i];
  int j = i;
  while(a[j-1]>v)
  {
   a[j] = a[j-1];
   j--;
  }
  a[j]=v;
 }
}

void bubblesort(int a[],long N)
{
 for(long i=N;i>=1;i--)
  for(int j=2;j<=i;j++)
   if(a[j-1]>a[j]) swap(a,j-1,j);
}

void quicksort(int a[],const int l,const int r)
{
 if(r>l)
 {
  const int v = a[r];
  long i=l-1;
  int j=r;
  for(;;)
  {
   while( a[++i]<v) ;
   while( a[--j]>v) ;
   if(i>=j) break;
   swap(a,i,j);
  }
  swap(a,i,r);
  quicksort(a,l,i-1);
  quicksort(a,i+1,r);
 }
}

// Heapsort

void downheap(int a[],long N,int v)
{
 int w=2*v+1;    // first descendant of v
 while (w<N)
 {
  if (w+1<N && a[w+1]>a[w]) w++;
  if (a[v]>=a[w]) return;
  swap(a,v,w);
  v=w;
  w=2*v+1;
 }
}

void heapsort(int a[],long N)
{
 for (int v=N/2-1; v>=0; v--) downheap(a,N,v);
 while (N>1)
 {
  N--;
  swap(a,0,N);
  downheap(a,N,0);
 }
}

// Beispielprogramm

int main(int argc,char **argv)
{
 long N;
 if(argc==2) N = atol(argv[1]); else N = 2000000;
 time_t last,n;
 int a[N];
 std::vector<int> v(N);

 std::cout << "\tSortieralgorithmen\n";
 std::cout << "\nAusgangsdaten:\t"<<N;

 for(long i=0;i<N;i++) a[i]=rand()%N;

 if(N<30) for(long i=0;i<N;i++) std::cout << " " << a[i];

 std::cout << "\nquicksort:\t";
 last = time(0);
 quicksort(a,0,N-1);
 n = time(0);
 std::cout << "("<<n-last<<"s)";
 if(N<30) for(long i=0;i<N;i++) std::cout << " " << a[i];

 for(long i=0;i<N;i++) a[i]=rand()%N;

 std::cout << "\nheapsort:\t";
 last = time(0);
 heapsort(a,N);
 n = time(0);
 std::cout << "("<<n-last<<"s)";
 if(N<30) for(long i=0;i<N;i++) std::cout << " " << a[i];

 for(long i=0;i<N;i++) a[i]=v[i]=rand()%N;

 std::cout << "\nstd::sort<int>:\t";
 last = time(0);
 std::sort(a,a+N);
 n = time(0);
 std::cout << "("<<n-last<<"s)";
 if(N<30) for(long i=0;i<N;i++) std::cout << " " << a[i];

 std::cout << "\nstd::sort<vector>:\t";
 last = time(0);
 std::sort(v.begin(),v.end());
 n = time(0);
 std::cout << "("<<n-last<<"s)";
 if(N<30) for(long i=0;i<N;i++) std::cout << " " << v[i];

 for(long i=0;i<N;i++) a[i]=rand()%N;

 std::cout << "\ninsertionsort:\t";
 last = time(0);
 insertionsort(a,N);
 n = time(0);
 std::cout << "("<<n-last<<"s)";
 if(N<30) for(long i=0;i<N;i++) std::cout << " " << a[i];

 for(long i=0;i<N;i++) a[i]=rand()%N;

 std::cout << "\nselectionsort:\t";
 last = time(0);
 selectionsort(a,N);
 n = time(0);
 std::cout << "("<<n-last<<"s)";
 if(N<30) for(long i=0;i<N;i++) std::cout << " " << a[i];

 for(long i=0;i<N;i++) a[i]=rand()%N;

 std::cout << "\nbubblesort:\t";
 last = time(0);
 bubblesort(a,N);
 n = time(0);
 std::cout << "("<<n-last<<"s)";
 if(N<30) for(long i=0;i<N;i++) std::cout << " " << a[i];

 std::cout << std::endl;
 return 0;
}

/* Beispielergebnisse
        Sortieralgorithmen

Ausgangsdaten:  100000
quicksort:      (0s)
heapsort:       (0s)
std::sort<int>: (0s)
std::sort<vector>:      (0s)
insertionsort:  (6s)
selectionsort:  (17s)
bubblesort:     (32s)

Ausgangsdaten:  2000000
quicksort:      (1s)
heapsort:       (2s)
std::sort<int>: (0s)
std::sort<vector>:      (0s)
.... Nach einer Stunde abgebrochen ...
*/