#include <iostream>
#include <time.h>

void inline swap(int a[],const int i,const int j)
{
 const int s = a[i];
 a[i] = a[j];
 a[j] = s;
}

void selectionsort(int a[],int N)
{
 int min;
 for(int i=0;i<N;i++)
 {
  min = i;
  for(int j=i+1;j<=N;j++)
   if(a[j]<a[min]) min=j;
  swap(a,min,i);
 }
}

void insertionsort(int a[],int N)
{
 for(int i=1;i<N;i++)
 {
  int v = a[i];
  int j = i;
  while(a[j-1]>v)
  {
   a[j] = a[j-1];
   j--;
  }
  a[j]=v;
 }
}

void bubblesort(int a[],int N)
{
 for(int i=N;i>=1;i--)
  for(int j=2;j<=i;j++)
   if(a[j-1]>a[j]) swap(a,j-1,j);
}

void quicksort(int a[],const int l,const int r)
{
 if(r>l)
 {
  const int v = a[r];
  int i=l-1;
  int j=r;
  for(;;)
  {
   while( a[++i]<v) ;
   while( a[--j]>v) ;
   if(i>=j) break;
   swap(a,i,j);
  }
  swap(a,i,r);
  quicksort(a,l,i-1);
  quicksort(a,i+1,r);
 }
}

// Heapsort

void downheap(int a[],int N,int v)
{
 int w=2*v+1;    // first descendant of v
 while (w<N)
 {
  if (w+1<N && a[w+1]>a[w]) w++;
  if (a[v]>=a[w]) return;
  swap(a,v,w);
  v=w;
  w=2*v+1;
 }
}

void heapsort(int a[],int N)
{
 for (int v=N/2-1; v>=0; v--) downheap(a,N,v);
 while (N>1)
 {
  N--;
  swap(a,0,N);
  downheap(a,N,0);
 }
}

// Beispielprogramm

int main()
{
 const int N = 16384;
 time_t last,n;
 int a[N],b[N],c[N],d[N],e[N];

 for(int i=0;i<N;i++) a[i]=b[i]=c[i]=d[i]=e[i]=rand();
 std::cout << "\tSortieralgorithmen\n";
 std::cout << "\nAusgangsdaten:\t"<<N;
 std::cout << "\nquicksort:\t";
 last = time(0);
 quicksort(d,0,N-1);
 n = time(0);
 std::cout << "("<<n-last<<"s)";
 std::cout << "\nheapsort:\t";
 last = time(0);
 heapsort(d,N);
 n = time(0);
 std::cout << "("<<n-last<<"s)";
 std::cout << "\ninsertionsort:\t";
 last = time(0);
 insertionsort(b,N);
 n = time(0);
 std::cout << "("<<n-last<<"s)";
 std::cout << "\nselectionsort:\t";
 last = time(0);
 selectionsort(a,N);
 n = time(0);
 std::cout << "("<<n-last<<"s)";
 std::cout << "\nbubblesort:\t";
 last = time(0);
 bubblesort(c,N);
 n = time(0);
 std::cout << "("<<n-last<<"s)";
 std::cout << std::endl;
 return 0;
}
